#include "VentanaButton.h"

/* Ejemplo bsico donde se puede ver como crear todos los tipos de botones existentes hasta windows vista */

#define ID_BOTON1       100
#define ID_GRUPO        101
#define ID_OPTION1      102
#define ID_OPTION2      103
#define ID_CHECK2       104
#define ID_CHECK3       105
#define ID_DEFAULT      106
#define ID_SPLIT        107
#define ID_LINK         108
#define ID_PRIVILEGIOS  109

HWND VentanaButton::Crear(void) {
    DVentana::Crear(NULL, TEXT("DWL_Ejemplo_Botones"), TEXT("Ejemplo Botones"), 100, 100, 300, 400, WS_OVERLAPPEDWINDOW);

    ButtonNormal.Crear(this, TEXT("Boton normal"), 10, 10, 100, 25, ID_BOTON1, WS_CHILD | WS_VISIBLE);

    Grupo.Crear(this, TEXT("Grupo"), 10, 40, 200, 80, ID_GRUPO, WS_CHILD | WS_VISIBLE | BS_GROUPBOX);
    Option1.Crear(&Grupo, TEXT("Radio button 1"), 10, 20, 120, 20, ID_OPTION1, WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON | WS_GROUP);
    Option2.Crear(&Grupo, TEXT("Radio button 2"), 10, 50, 120, 20, ID_OPTION2, WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON);

    CheckBox2.Crear(this, TEXT("CheckBox 2 estados"), 10, 130, 200, 20, ID_CHECK2, WS_CHILD | WS_VISIBLE | BS_AUTOCHECKBOX);
    CheckBox3.Crear(this, TEXT("CheckBox 3 estados"), 10, 160, 200, 20, ID_CHECK3, WS_CHILD | WS_VISIBLE | BS_AUTO3STATE);

    DefaultButton.Crear(this, TEXT("Boton por defecto"), 10, 190, 150, 25, ID_DEFAULT, WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON);

    SplitButton.Crear(this, TEXT("Boton Split"), 10, 220, 150, 25, ID_SPLIT, WS_CHILD | WS_VISIBLE | BS_SPLITBUTTON);

    LinkButton.Crear(this, TEXT("Boton Link"), 10, 250, 150, 40, ID_LINK, WS_CHILD | WS_VISIBLE | BS_COMMANDLINK | BS_NOTIFY);

    BotonPrivilegios.Crear(this, TEXT("Privilegios Admin"), 10, 300, 200, 25, ID_PRIVILEGIOS, WS_CHILD | WS_VISIBLE);
    BotonPrivilegios.IconoElevarPrivilegios(TRUE);

    Visible(true);
    return _hWnd;
}